/***
 *       _____                         _   
 *      / ____|                       | |  
 *     | (___     ___   _ __     ___  | |_ 
 *      \___ \   / _ \ | '_ \   / _ \ | __|
 *      ____) | |  __/ | | | | |  __/ | |_ 
 *     |_____/   \___| |_| |_|  \___|  \__|
 *         (C) 2016 Senet, Inc                                
 *                                         
 */
#include "board_udk.h"
#include "board_evb.h"
#include "ChannelPlans.h"

CBoard* CBoard::boardPtr       = 0;
PB_FUNC CBoard::buttonCallback = 0;;
mDot           *mDotPtr        = 0;

EBoardStatus BoardInit()
{
#ifdef MTDOT_UDK
	new CBoardUDK();
#elif MTDOT_EVB
	new CBoardEVB();
#else
#error Need to define board type ( MTDOT_UDK or MTDOT_EVB)
#endif

	return ( ( CBoard::boardPtr != 0 ) ? CBoard::boardPtr->init() : Board_Fail);
}


EBoardStatus CBoard::init()
{
	lora::ChannelPlan* plan = new lora::ChannelPlan_US915();
	assert(plan);

	mDotPtr = mDot::getInstance(plan);
	assert(mDotPtr);

	debugUART.baud(115200);

	return Board_Ok;
}
