/***
 *       _____                         _   
 *      / ____|                       | |  
 *     | (___     ___   _ __     ___  | |_ 
 *      \___ \   / _ \ | '_ \   / _ \ | __|
 *      ____) | |  __/ | | | | |  __/ | |_ 
 *     |_____/   \___| |_| |_|  \___|  \__|
 *         (C) Senet, Inc                                
 *                                         
 */
#ifndef BOARD_EVB_BOARD_EVB_H_
#define BOARD_EVB_BOARD_EVB_H_
#include "board.h"

class CBoardEVB : public CBoard
{
	protected:

        CBoardEVB();

		virtual EBoardStatus init();
		virtual EBoardStatus readSensors ( BoardSensorData &data );
		virtual EBoardStatus start();
		virtual EBoardStatus setLED(uint8_t ledNum, bool on);
		virtual EBoardStatus toggleLED(uint8_t ledNum);
		virtual void         pb1ISR();
		virtual void         pb2ISR();
		virtual void         pb1_debounce();
		virtual void         pb2_debounce();

	friend EBoardStatus BoardInit();
};




#endif /* BOARD_EVB_BOARD_EVB_H_ */
