/*-
 * Copyright (c) 2012-2013 Jan Breuer,
 *
 * All Rights Reserved
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file   main.c
 * @date   Thu Nov 15 10:58:45 UTC 2012
 * 
 * @brief  SCPI parser test
 * 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "scpi/scpi.h"
#include "../common/scpi-def.h"
#include "mbed.h"
#include "timer.h"



Serial pc(USBTX, USBRX);

#ifdef TARGET_MOTE_L152RC
    #define LED_TIMEOUT 50000 // usec
    DigitalOut RedLed( PB_1 );     // Active Low
    DigitalOut YellowLed( PB_10 ); // Active Low
    DigitalOut UsrLed( PA_5 );     // Active High
    TimerEvent_t RedLedTimer;
    static void OnInputEvent( void );
#endif /* TARGET_MOTE_L152RC */

#ifdef TARGET_MOTE_L152RC
#endif /* TARGET_MOTE_L152RC */


char smbuffer[64];

size_t SCPI_Write(scpi_t * context, const char * data, size_t len) {
    (void) context;
    return fwrite(data, 1, len, stdout);
}

scpi_result_t SCPI_Flush(scpi_t * context) {    
    fflush(stdout);
    return SCPI_RES_OK;
}

int SCPI_Error(scpi_t * context, int_fast16_t err) {
    (void) context;

    printf("**ERROR: %d, \"%s\"\r\n", (int32_t) err, SCPI_ErrorTranslate(err));
    return 0;
}

scpi_result_t SCPI_Control(scpi_t * context, scpi_ctrl_name_t ctrl, scpi_reg_val_t val) {
    if (SCPI_CTRL_SRQ == ctrl) {
        printf("**SRQ: 0x%X (%d)\r\n", val, val);
    } else {
        printf("**CTRL %02x: 0x%X (%d)\r\n", ctrl, val, val);
    }
    return SCPI_RES_OK;
}

/**
 * Return 0 as OK and other number as error
 */
scpi_result_t SCPI_Test(scpi_t * context) {
    printf("**Test\r\n");
    return (scpi_result_t)0;
}



scpi_result_t SCPI_SystemCommTcpipControlQ(scpi_t * context) {
    return SCPI_RES_ERR;
}
/*
 * 
 */
int get_kbd_str(char* buf, int size)
{
    char c;
    int i;
    static int prev_len;
    
    for (i = 0;;) {
        if (pc.readable()) {
            c = pc.getc();
            if (c == 8) {   // backspace
                if (i > 0) {
                    pc.putc(8);
                    pc.putc(' ');
                    pc.putc(8);
                    i--;
                }
            } else if (c == '\r') {
                if (i == 0) {
                    return prev_len; // repeat previous
                } else {
                    buf[i++] = c;
                    buf[i] = 0; // null terminate
                    prev_len = i;
                    pc.putc('\r');
                    pc.putc('\n');
                    return i;
                }
            } else if (c == 3) {
                // ctrl-C abort
                //abort_key = true;
                return -1;
            } else if (i < size) {
                buf[i++] = c;
                pc.putc(c);
            }
        } else {
            /* service something */
            service_radio();
        }
    } // ...for()
}

int main(int argc, char** argv) {
    (void) argc;
    (void) argv;
    //int result;
    
    scpi_def_init();

    SCPI_Init(&scpi_context);

    printf("\r\nreset\r\n");


#ifdef TARGET_MOTE_L152RC
    RedLed = 1;
    YellowLed = 1;
    UsrLed = 1;
    TimerInit( &RedLedTimer, OnInputEvent);
#endif /* TARGET_MOTE_L152RC */



    while (1) {
         //fgets(smbuffer, 10, stdin); 

         int len = get_kbd_str(smbuffer, sizeof(smbuffer));
         if (len > 0) {      
#ifdef TARGET_MOTE_L152RC
            /* Blink Red LED on keyboard entry */
            RedLed = 0;
            TimerSetValue( &RedLedTimer, LED_TIMEOUT ); // set blink LED to 750ms
            TimerStart( &RedLedTimer );
#endif /* TARGET_MOTE_L152RC */                   
            /*result =*/ SCPI_Input(&scpi_context, smbuffer, len);
        }
    }

    //return (EXIT_SUCCESS);
}

#ifdef TARGET_MOTE_L152RC
static void OnInputEvent( void )
{
    TimerStop( &RedLedTimer);

    RedLed = 1;
}
#endif /* TARGET_MOTE_L152RC */