// Organizationally Unique Identifier
#define OUI         0x00, 0x00, 0x00

/* DEVEUI = {[OUI] [5 bytes of Unique ID]}
if last 4 bytes of DEVEUI equals 0, then the firmware will assign a unique ID
*/
#define DEVEUI      OUI, 0x00, 0x00, 0x00, 0x00, 0x00

#define APPEUI      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
#define DEVKEY      0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF

// Time between transmissions in msec
#define MS_DELAY_NEXT_TX        3000

// Length of payload (Must be within the Maximum Length as defined in 7.2.6 of LoRaWAN 1.0 Specification
#define PAYLOAD_LENGTH          11  

/* DR_SF10 = 0, DR_SF9 = 1, DR_SF8 = 2, DR_SF7 = 3, DR_SF8C = 4  [as defined in Table 18 of Section 7 of LoRaWAN 1.0 Specification */
#define FIXED_DR                DR_SF10 

/* US 915MHz ISM Band */
#define CFG_us915

/* SX1272 chip */
#define CFG_sx1272_radio

// 0-7 to select block of 8 channels (Block A = 0, Block B = 1 ... Block H = 7). Comment this line to enable all 64 channels
#define CHNL_HYBRID     0       

// Set Tx Power in dBm (Max = 30dBm for frequency hopping over 50channels; 26dBm with Digital Modulation; 21dBm in Hybrid mode)
#define FIXED_TX_POWER  20      
