//#include "oslmic.h"
#include "lmic.h"
#include "debug.h"
#include "mbed.h"

Serial pc(USBTX, USBRX);

static DigitalOut red_led(PB_1);
#define LED_ON  0
#define LED_OFF 1

void debug_init()
{
    pc.baud(115200);

    // print banner
    debug_str("\r\n============== DEBUG STARTED ==============\r\n");

    red_led = LED_OFF;
}

void debug_str (const char* str)
{
    debug("%s", str);
}

void debug_event (int ev)
{
    static const u1_t* evnames[] = {
        [EV_SCAN_TIMEOUT]   = "SCAN_TIMEOUT",
        [EV_BEACON_FOUND]   = "BEACON_FOUND",
        [EV_BEACON_MISSED]  = "BEACON_MISSED",
        [EV_BEACON_TRACKED] = "BEACON_TRACKED",
        [EV_JOINING]        = "JOINING",
        [EV_JOINED]         = "JOINED",
        [EV_RFU1]           = "RFU1",
        [EV_JOIN_FAILED]    = "JOIN_FAILED",
        [EV_REJOIN_FAILED]  = "REJOIN_FAILED",
        [EV_TXCOMPLETE]     = "TXCOMPLETE",
        [EV_LOST_TSYNC]     = "LOST_TSYNC",
        [EV_RESET]          = "RESET",
        [EV_RXCOMPLETE]     = "RXCOMPLETE",
        [EV_LINK_DEAD]      = "LINK_DEAD",
        [EV_LINK_ALIVE]     = "LINK_ALIVE",
    };

    debug("%s\r\n", evnames[ev]);
}

void debug_val (const char* label, u4_t val)
{
    debug("%s%d\r\n", label, val);
}

void debug_buf(const u1_t* buf, u2_t len)
{
    while (len--) {
        debug("%02x ", *buf++);
    }
    debug("\r\n");
}

void debug_led(unsigned char on)
{
    if (on)
        red_led = LED_ON;
    else
        red_led = LED_OFF;
}

void debug_done()
{
    volatile int i;
    
    /* block until last bit sent out debug UART */
    while (!(USART2->SR & UART_FLAG_TC))
        __NOP();
        
    for (i = 0; i < 0x200; i++)
        __nop();
}
