/*
  ______                              _
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2016 Semtech

Description: Main program

Maintainer: Gregory Cristian & Gilbert Menth
*/

#include "mbed.h"
#include "Timers.h"
#include "Menu.h"
#include "Eeprom.h"
#include "stm32l4xx_hal.h"

/*!
 * \brief Define IO for Unused Pin
 */
DigitalOut F_CS( D6 );      // MBED description of pin
DigitalIn blueButton( USER_BUTTON );

void baud( int baudrate ) 
{
    Serial s( USBTX, USBRX );
    s.baud( baudrate );
}

int main( ) 
{
    uint8_t currentPage = START_PAGE;
    uint8_t demoStatusUpdate = 0;
    uint8_t deviceConnected = 0;
    uint8_t matchingFreq = 0;

    if( blueButton == 0 )
    {
        EepromEraseCheckSum( );
        NVIC_SystemReset( );
    }

    baud( 115200 );     // change here to increase or decrease the speed of the UART print

    F_CS = 1;

    deviceConnected = GetConnectedDevice( );
    matchingFreq = GetMatchingFrequency( );

    EepromInit( deviceConnected, matchingFreq );
    InitDemoApplication( );
    MenuInit( deviceConnected, matchingFreq );
    TimersInit( );

    printf( "Start SX126xDevKit : %s\n\r", FIRMWARE_VERSION );

    while( 1 )
    {
        currentPage = MenuHandler( demoStatusUpdate );

        switch( currentPage )
        {
            case START_PAGE:
                break;

            case PAGE_PING_PONG:
                demoStatusUpdate = RunDemoApplicationPingPong( );
                break;

            case PAGE_PER:
                demoStatusUpdate = RunDemoApplicationPer( );
                break;

            case PAGE_RSSI_TEST:
                demoStatusUpdate = RunDemoTestRssi( );
                break;

            case PAGE_SLEEP_MODE:
                demoStatusUpdate = RunDemoSleepMode( );
                break;

            case PAGE_STBY_RC_MODE:
                demoStatusUpdate = RunDemoStandbyRcMode( );
                break;

            case PAGE_STBY_XOSC_MODE:
                demoStatusUpdate = RunDemoStandbyXoscMode( );
                break;

            case PAGE_TX_CW:
                demoStatusUpdate = RunDemoTxCw( );
                break;

            case PAGE_CONT_MODULATION:
                demoStatusUpdate = RunDemoTxContinuousModulation( );
                break;

            case PAGE_CONT_RX:
                demoStatusUpdate = RunDemoRxContinuous( );
                break;
            case PAGE_UTILITIES:
                break;

            default:    // Any page not running a demo
                break;
        }
    }
}
