/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Compliance Test for LoRaWAN End-Device

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#include "ComplianceTest.h"


void PrepareComplianceTestFrame( McpsIndication_t *mcpsIndication )
{
    uint8_t *pData;

    pData = &mcpsIndication->Buffer[0];
    
    if( ComplianceTest.Running == false )
    {
        // Check compliance test enable command (i)
        if( ( mcpsIndication->BufferSize == 4 ) && 
            ( pData[0] == 0x01 ) && ( pData[1] == 0x01 ) && ( pData[2] == 0x01 ) && (pData[3] == 0x01 ) )
        {
            IsTxConfirmed = false;
            AppPort = 224;
            AppDataSize = 2;
            ComplianceTest.DownLinkCounter = 0;
            ComplianceTest.LinkCheck = false;
            ComplianceTest.DemodMargin = 0;
            ComplianceTest.NbGateways = 0;
            ComplianceTest.Running = true;
            ComplianceTest.State = 1;

            MibRequestConfirm_t mibReq;
            mibReq.Type = MIB_ADR;
            mibReq.Param.AdrEnable = true;
            LoRaMacMibSetRequestConfirm( &mibReq );

            Gps.enable( false );
        }
    }
    else
    {    
        ComplianceTest.State = pData[0];
        switch( ComplianceTest.State )
        {
        case 0: // Check compliance test disable command (ii)
            DisableComplianceTest( );
            break;
        case 1: // (iii, iv)
            AppDataSize = 2;
            break;
        case 2: // Enable confirmed messages (v)
            IsTxConfirmed = true;
            ComplianceTest.State = 1;
            break;
        case 3:  // Disable confirmed messages (vi)
            IsTxConfirmed = false;
            ComplianceTest.State = 1;
            break;
        case 4: // (vii)
            AppDataSize = mcpsIndication->BufferSize;
            
            if( AppDataSize > LORAWAN_APP_DATA_MAX_SIZE )
                AppDataSize = LORAWAN_APP_DATA_MAX_SIZE;
            
            AppData[0] = 4;
            for( uint8_t i = 1; i < AppDataSize; i++ )
            {
                AppData[i] = mcpsIndication->Buffer[i] + 1; 
            }
            break;
        case 5: // (viii)
            {
                MlmeReq_t mlmeReq;
                mlmeReq.Type = MLME_LINK_CHECK;
                LoRaMacMlmeRequest( &mlmeReq );
            }
            break;
        case 6: // (viii)
            {
                MlmeReq_t mlmeReq;

                Otaa = true;

                mlmeReq.Type = MLME_JOIN;

                mlmeReq.Req.Join.DevEui = DevEui;
                mlmeReq.Req.Join.AppEui = AppEui;
                mlmeReq.Req.Join.AppKey = AppKey;
                mlmeReq.Req.Join.NbTrials = 3;

                LoRaMacMlmeRequest( &mlmeReq );

                Gps.enable( true );
                DeviceState = DEVICE_STATE_SLEEP;
            }
            break;
        case 7: // (x)
            {
                if( mcpsIndication->BufferSize == 3 )
                {
                    MlmeReq_t mlmeReq;
                    mlmeReq.Type = MLME_TXCW;
                    mlmeReq.Req.TxCw.Timeout = ( uint16_t )( ( mcpsIndication->Buffer[1] << 8 ) | mcpsIndication->Buffer[2] );
                    LoRaMacMlmeRequest( &mlmeReq );
                }
                ComplianceTest.State = 1;
            }
            break;
        default:
            break;
        }
    }
}

void RunComplianceTest( void )
{
    if( ComplianceTest.LinkCheck == true )
    {
        ComplianceTest.LinkCheck = false;
        AppDataSize = 3;
        AppData[0] = 5;
        AppData[1] = ComplianceTest.DemodMargin;
        AppData[2] = ComplianceTest.NbGateways;
        ComplianceTest.State = 1;
    }
    else
    {
        switch( ComplianceTest.State )
        {
        case 1:
            AppDataSize = 2;
            AppData[0] = ComplianceTest.DownLinkCounter >> 8;
            AppData[1] = ComplianceTest.DownLinkCounter;
            break;
        case 4:
            ComplianceTest.State = 1;
            break;
        default:
            break;
        }
    }
}

void DisableComplianceTest( void )
{
    IsTxConfirmed = LORAWAN_CONFIRMED_MSG_ON;
    AppPort = LORAWAN_APP_PORT;
    AppDataSize = LORAWAN_APP_DATA_SIZE;
    ComplianceTest.DownLinkCounter = 0;
    ComplianceTest.Running = false;
    
    MibRequestConfirm_t mibReq;
    mibReq.Type = MIB_ADR;
    mibReq.Param.AdrEnable = LORAWAN_ADR_ON;
    LoRaMacMibSetRequestConfirm( &mibReq );

    Gps.enable( true );
}
