/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Extern declaration of parameters defined in main.cpp

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/
#ifndef __COMMON_H__
#define __COMMON_H__

#include "Commissioning.h"
#include "board.h"

/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_MAX_SIZE                           242

/*!
 * Current network ID
 */
#define LORAWAN_NETWORK_ID                          ( uint32_t )0

/*
 * Indicates if the end-device is currently activated by OTAA procedure.
 */
extern bool Otaa;

/*!
 * Over the Air Activation 
 */

extern uint8_t DevEui[];
extern uint8_t AppEui[];
extern uint8_t AppKey[];

#if( OVER_THE_AIR_ACTIVATION == 0 )
/*!
 * Activation by Personalization 
 */

extern uint8_t NwkSKey[];
extern uint8_t AppSKey[];
extern uint32_t DevAddr;

#endif

extern uint8_t AppData[LORAWAN_APP_DATA_MAX_SIZE]; //  User application data size

extern uint8_t AppPort; // Application port

extern uint8_t AppDataSize; // Application size

extern uint8_t IsTxConfirmed; // Indicates if the node is sending confirmed or unconfirmed messages

extern bool IsTxIntUpdate; // Indicates if a new transmit interrupt can be set

extern bool NextTx; // Indicates if a new packet can be sent

extern bool IsNetworkJoinedStatusUpdate; // Indicates if the MAC layer network join status has changed.

extern bool IsTxUpdate; // Indicates if the message sent

extern bool IsRxUpdate; // Indicates if the message received in the RX window.

extern TimerEvent_t TxNextPacketTimer; // Timer to handle the application data transmission duty cycle

#endif // __COMMON_H__
