#include "mbed.h"
#include <ros.h>
#include "hallsensor_software_decoder.h"
#include <geometry_msgs/Twist.h>

#define Ts 0.01f 
#define ACC 0.1f //0.1 rpm/s^2

Ticker timer1;

PwmOut pwm1(D7);
PwmOut pwm1n(D11);
PwmOut pwm2(D8);
PwmOut pwm2n(A3);

void init_TIMER();
void init_PWM(); 
void timer1_ITR();


float rotation_speed_1 = 0.0;
float rotation_speed_ref_1 = 0;
float rotation_speed_CMD_1 = 0;
float pwm1_duty = 0.5;
double PI_out_1 = 0.0;
float err_1 = 0.0;
float ierr_1 = 0.0;

float rotation_speed_2 = 0.0;
float rotation_speed_ref_2 = -0;
float rotation_speed_CMD_2 = 0;
float pwm2_duty = 0.5;
float PI_out_2 = 0.0;
float err_2 = 0.0;
float ierr_2 = 0.0;

float feedDuty1 = 0.5;
float feedDuty2 = 0.5;
float wheelSpeed1 = 0;
float wheelSpeed2 = 0;

float r = 0.03; // wheel radius (m)
float L = 0.27; // car width (m)

float V_ref = 0; // (m/s) max: 0.25
float V = 0;
float W_ref = 0;  // (rad/s)
float W = 0;

float V_CMD = 0;
float W_CMD = 0;


float Kp = 0.008;
float Ki = 0.02;

Serial pc(USBTX, USBRX);

//rosserial
ros::NodeHandle nh;

geometry_msgs::Twist vel_msg;
ros::Publisher p("feedback_Vel", &vel_msg);

int runCount = 0;
int printCount = 0;

void messageCallback(const geometry_msgs::Twist &msg_receive)
{
    
    V_ref = msg_receive.linear.x;
    W_ref = msg_receive.angular.z;

  
    /*
    err_1 = 0;
    ierr_1 = 0;
    PI_out_1 = 0;
    err_2 = 0;
    ierr_2 = 0;
    PI_out_2 = 0;
    */
    
    wheelSpeed1 = (-V_ref / r - L * W_ref / 2.0f / r) *1.0f;
    
    if(wheelSpeed1 > 0)
    {feedDuty1 = 0.0519 * wheelSpeed1 + 0.5589;}
    else
    {feedDuty1 = 0.0519 * wheelSpeed1 + 0.4411;}
    
    if(feedDuty1 > 1)
    {feedDuty1 = 1;}
    else if(feedDuty1 < 0)
    {feedDuty1 = 0;}
    
    
    wheelSpeed2 = (V_ref / r - L * W_ref / 2.0f / r) *1.0f;
        
    if(wheelSpeed2 > 0)
    {feedDuty2 = 0.0519 * wheelSpeed2 + 0.5589;}
    else
    {feedDuty2 = 0.0519 * wheelSpeed2 + 0.4411;}
    
    if(feedDuty2 > 1)
    {feedDuty2 = 1;}
    else if(feedDuty2 < 0)
    {feedDuty2 = 0;}
    
    //feedDuty2 = 1 - feedDuty1;
    
    if ((V_ref<0.01 && V_ref > -0.01) && (W_ref<0.01 && W_ref > -0.01))
    {feedDuty1 = 0.5; feedDuty2 = 0.5;}
}

ros::Subscriber<geometry_msgs::Twist> s("cmd_vel",messageCallback);


int main()
{
    //pc.baud(57600);
    
    init_TIMER();
    init_PWM();
    init_CN();
    
    nh.initNode();
    nh.subscribe(s);
    nh.advertise(p);
    
    while(1) {
        V = ((rotation_speed_2 - rotation_speed_1) * r / 2.0f )* 2.0f * 3.14f / 60.0f;
        W = (-1.0f * r * (rotation_speed_1 + rotation_speed_2) / L) * 2.0f * 3.14f / 60.0f;
        //V = r*(rotation_speed_2-rotation_speed_1)/4.0f * 2.0f * 3.14f / 60.0f;
        //W = (-1.0f * r * (rotation_speed_1 + rotation_speed_2) / (2.0f*L) ) * 2.0f * 3.14f / 60.0f;
        
        /*
        if(runCount < 500)
        {runCount ++;V_ref = 0.15;}
        else if (runCount < 1000)
        {runCount ++;V_ref = -0.15;}
        else
        {runCount = 0;}
        
        
        wheelSpeed1 = (-V_ref / r - L * W_ref / 2.0f / r) *1.0f;
    
        if(wheelSpeed1 > 0)
        {feedDuty1 = 0.0519 * wheelSpeed1 + 0.5589;}
        else
        {feedDuty1 = 0.0519 * wheelSpeed1 + 0.4411;}
        
        if(feedDuty1 > 1)
        {feedDuty1 = 1;}
        else if(feedDuty1 < 0)
        {feedDuty1 = 0;}
        
        
        wheelSpeed2 = (V_ref / r - L * W_ref / 2.0f / r) *1.0f;
            
        if(wheelSpeed2 > 0)
        {feedDuty2 = 0.0519 * wheelSpeed2 + 0.5589;}
        else
        {feedDuty2 = 0.0519 * wheelSpeed2 + 0.4411;}
        
        if(feedDuty2 > 1)
        {feedDuty2 = 1;}
        else if(feedDuty2 < 0)
        {feedDuty2 = 0;}
        
        
        printCount++;
        if(printCount > 10)
        {
            printCount = 0; 
            //pc.printf("V = %0.3f, W = %0.3f, feedDuty1 = %0.3f, feedDuty2 = %0.3f\r\n", V_ref,W_ref,feedDuty1,feedDuty2);
            pc.printf("%0.3f\n", V);
        }
        */
        
        //pc.printf("motor_1 = %f,\t motor_2 = %f\r\n", rotation_speed_1,rotation_speed_2);
        //pc.printf("V = %f, W = %f\r\n", V,W);
        
        vel_msg.linear.x = V;
        vel_msg.angular.z = W;
        
        p.publish(&vel_msg);
        
        nh.spinOnce();
        
        wait_ms(10);
    }
}



void init_TIMER()
{
    timer1.attach_us(&timer1_ITR, 10000.0); // the address of the function to be attached (timer1_ITR) and the interval (10000 micro-seconds)
}


void init_PWM()
{
    pwm1.period_us(50);
    pwm1.write(0.5);
    TIM1->CCER |= 0x4;

    pwm2.period_us(50);
    pwm2.write(0.5);
    TIM1->CCER |= 0x40;
}


void timer1_ITR()
{
    
    rotation_speed_CMD_1 = (-V_ref / r - L * W_ref / 2.0f / r) / 2.0f / 3.14f * 60.0f;
    rotation_speed_CMD_2 = (V_ref / r - L * W_ref / 2.0f / r) / 2.0f / 3.14f * 60.0f;
    
    
    if (rotation_speed_ref_1 > rotation_speed_CMD_1)
        rotation_speed_ref_1 -= ACC;
    else
        rotation_speed_ref_1 += ACC;
        
    if (rotation_speed_ref_2 > rotation_speed_CMD_2)
        rotation_speed_ref_2 -= ACC;
    else
        rotation_speed_ref_2 += ACC;
        
        
    // motor1

    rotation_speed_1 = -(float)speed_count_1 * 100.0f / 48.0f * 60.0f / 56.0f;   //unit: rpm
    speed_count_1 = 0;
    
    //acceleration control
    
    
    
    ///PI controller for motor1///
    
    err_1 = rotation_speed_ref_1 - rotation_speed_1;
    ierr_1 = ierr_1 + Ts * err_1;
    if(ierr_1 > 50.0f)
    {
        ierr_1 = 50.0;
    }
    else if(ierr_1 < -50.0f)
    {
        ierr_1 = -50.0;
    }
    PI_out_1 = (Kp * err_1 + Ki * ierr_1);
    
    //////////////////////////////
    float PI_out_1_feed = PI_out_1 + feedDuty1;
    if(PI_out_1_feed >= 1)PI_out_1_feed = 1;
    else if(PI_out_1_feed <= 0)PI_out_1_feed = 0;
    
    //pwm1_duty = PI_out_1 + 0.5f;
    //pwm1_duty = feedDuty1;
    pwm1_duty = PI_out_1_feed;
    pwm1.write(pwm1_duty);
    TIM1->CCER |= 0x4;
    
   
    
    
   //motor2
  

    rotation_speed_2 = -(float)speed_count_2 * 100.0f / 48.0f * 60.0f / 56.0f;   //unit: rpm
    speed_count_2 = 0;
    
   

    ///PI controller for motor2///
    err_2 = rotation_speed_ref_2 - rotation_speed_2;
    ierr_2 = ierr_2 + Ts * err_2;
    if(ierr_2 > 50.0f)
    {
        ierr_2 = 50.0;
    }
    else if(ierr_2 < -50.0f)
    {
        ierr_2 = -50.0;
    }
    PI_out_2 = (Kp * err_2 + Ki * ierr_2) ;
    
    //////////////////////////////
    float PI_out_2_feed = PI_out_2 + feedDuty2;
    if(PI_out_2_feed >= 1)PI_out_2_feed = 1;
    else if(PI_out_2_feed <= 0)PI_out_2_feed = 0;
    
    //pwm2_duty = PI_out_2 + 0.5f;
    //pwm2_duty = feedDuty2;
    pwm2_duty = PI_out_2_feed;
    pwm2.write(pwm2_duty);
    TIM1->CCER |= 0x40;
    

}