/*
 software decoder is for motor2
 "speed_count_2" can save the decoded data after one run the function "init_CH()"
*/

#ifndef _HALLSENSOR_SOFTWARE_DECODER_H
#define _HALLSENSOR_SOFTWARE_DECODER_H


#include "mbed.h"

InterruptIn HallA_1(A1);
InterruptIn HallB_1(A2);
InterruptIn HallA_2(D13);
InterruptIn HallB_2(D12);

void init_CN();
void CN_ITR();

int for_back_1 = 0;  // for_back = 1 -> forward   for_back = 0 -> backward
int for_back_2 = 0;  // for_back = 1 -> forward   for_back = 0 -> backward

int HallA_1_state = 0;
int HallB_1_state = 0;
int state_1 = 0;
int state_1_old = 0;

int HallA_2_state = 0;
int HallB_2_state = 0;
int state_2 = 0;
int state_2_old = 0;

int speed_count_1;
int speed_count_2;

void init_CN()
{
    HallA_1.rise(&CN_ITR);
    HallA_1.fall(&CN_ITR);
    HallB_1.rise(&CN_ITR);
    HallB_1.fall(&CN_ITR);    
    HallA_2.rise(&CN_ITR);
    HallA_2.fall(&CN_ITR);
    HallB_2.rise(&CN_ITR);
    HallB_2.fall(&CN_ITR);

}

void CN_ITR()
{
        // motor1
    HallA_1_state = HallA_1.read();
    HallB_1_state = HallB_1.read();

    ///code for state determination///
    state_1 = 2 * HallA_1_state + (((~HallA_1_state)&&HallB_1_state) || (HallA_1_state && (~HallB_1_state))) + 1;
    
    
    if(state_1 == 1)
    {
        if(state_1_old == 4)
        {
            for_back_1 = 1;
        }
        else if(state_1_old != 1)
        {
            for_back_1 = 0;
        }
    }
    else if(state_1 == 4)
    {
        if(state_1_old == 1)
        {
            for_back_1 = 0;
        }
        else if(state_1_old != 4)
        {
            for_back_1 = 1;
        }
    }
    else
    {
        if(state_1 > state_1_old)
        {
            for_back_1 = 1;
        }
        else if(state_1 < state_1_old)
        {
            for_back_1 = 0;
        }   
    }        
    if(state_1_old != state_1)
    {
        if(for_back_1 == 1)
        {
             speed_count_1 = speed_count_1 + 1; 
        }
        else
        {
             speed_count_1 = speed_count_1 - 1; 
        }
        
    }    
    
    state_1_old = state_1; 
    
    
    
    // motor2
    HallA_2_state = HallA_2.read();
    HallB_2_state = HallB_2.read();

    ///code for state determination///
    state_2 = 2 * HallA_2_state + (((~HallA_2_state)&&HallB_2_state) || (HallA_2_state && (~HallB_2_state))) + 1;
    
    
    if(state_2 == 1)
    {
        if(state_2_old == 4)
        {
            for_back_2 = 1;
        }
        else if(state_2_old != 1)
        {
            for_back_2 = 0;
        }
    }
    else if(state_2 == 4)
    {
        if(state_2_old == 1)
        {
            for_back_2 = 0;
        }
        else if(state_2_old != 4)
        {
            for_back_2 = 1;
        }
    }
    else
    {
        if(state_2 > state_2_old)
        {
            for_back_2 = 1;
        }
        else if(state_2 < state_2_old)
        {
            for_back_2 = 0;
        }   
    }        
    if(state_2_old != state_2)
    {
        if(for_back_2 == 1)
        {
             speed_count_2 = speed_count_2 + 1; 
        }
        else
        {
             speed_count_2 = speed_count_2 - 1; 
        }
        
    }    
    
    state_2_old = state_2; 
    
}


#endif 
