#include "ADXL345_I2C.h"

#define DEBUG

#ifdef DEBUG
#include "USBSerial.h"                       // To use USB virtual serial, a driver is needed, check http://mbed.org/handbook/USBSerial
#define LOG(args...)    pc.printf(args)
USBSerial pc;
#else
#define LOG(args...)
#endif

ADXL345_I2C accelerometer(P0_5, P0_4);

int main()
{
    int readings[3] = {0, 0, 0};

    LOG("Starting ADXL345 test...\n");
    LOG("Device ID is: 0x%02x\n", accelerometer.getDeviceID());
 
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
 
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
     
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
 
    //Measurement mode.
    accelerometer.setPowerControl(0x08);

    while (1) {
        accelerometer.getOutput(readings);
        LOG("%i, %i, %i\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
        
        wait(1);
    }

}
