#include "mbed.h"
#include "math.h"

// Measure duration of time that the signal is low in a 30sec period.

InterruptIn input(PA_0); // Change your pin name here
Timer t;    // measure amount of time signal is low
Ticker m;   // every 30 seconds calculate measurement

// Start Timer
void start(void){
    t.start();
}

// Stop TImer
void stop(void){
    t.stop();
}

// calculate sensor value
void calculate(){
    // run measurements
    int lpo = t.read_us();
    float ratio = t.read_us()/(30000*10.0);
    float concentration = 1.1*pow(ratio,3)-3.8*pow(ratio,2)+520*ratio+0.62;
    printf("\r\nlpo = %d, r = %f, c = %f pcs/0.01cf\r\n",lpo,ratio,concentration);
    
    // reset and run sensors
    t.reset(); // reset mesurement every 30 seconds
    input.fall(&start); // start measuring when signal is low
    input.rise(&stop);  // stop measuring when signal is high
}

int main(){
    printf("\r\n Starting...\r\n");
    m.attach(&calculate,30.0); // measure for 30 seconds
    while(1){
        ;
    }
}