#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"
#include "Grove_temperature.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "Servo.h"

#if !defined(TARGET_WIO_3G)
#error Selected target is not supported.
#endif

#define D20 (PB_4)
#define D19 (PB_3)

// on-board resources

Serial pc(USBTX, USBRX, 115200);
DigitalOut GrovePower(PB_10, 1);

#define WS2812_BUF 8
#define NUM_COLORS 8
#define NUM_LEDS_PER_COLOR 8
#define H0 8
#define L0 32
#define H1 17
#define L1 32
 
DigitalOut LEDPower(PE_8, 1);
PixelArray px(WS2812_BUF);
WS2812 ws(PB_1, WS2812_BUF, H0, L0, H1, L1);

// Grove sensors

DigitalOut led1(D38);
AnalogIn ain(A6); // angle or light sensor
InterruptIn btn(D20); // button or touch sensor
Grove_LCD_RGB_Backlight lcd(I2C_SDA, I2C_SCL);
Grove_temperature temp(A4);

uint32_t button = 0;

void push()
{
    button++;
}


int main()
{
    char buf[20];
    btn.fall(push); // set interrupt handler

    lcd.clear();
    lcd.setRGB(0xff, 0x00, 0x00);
    lcd.locate(0, 0);
    lcd.print("Hello World!");
    lcd.locate(0, 1);

    // set up the colours we want to draw with
    const int colorbuf[NUM_COLORS] = {0x000000, 0x2f0000,0x2f2f00,0x002f00,0x002f2f,0x00002f,0x2f002f, 0x2f2f2f};
 
    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling

    // for each of the colours (j) write out 10 of them
    // the pixels are written at the colour*10, plus the colour position
    // all modulus 60 so it wraps around
    for (int i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[i]);
        px.SetI(i, 0x80);
    }
 
    pc.printf("hello, Mbed world\n");

    int cnt = 0;
    int idx = 0;

    while (true) {
        pc.printf("count = %4d, button = %d, analog = %2.2f, temp = %2.2f\n", cnt++, button, ain.read(), temp.getTemperature());
        sprintf(buf, "L=%2.2f, T=%2.2f", ain.read(), temp.getTemperature());
        
        lcd.setRGB(0xff, (255*ain.read()), 0x00);
        lcd.locate(0, 1);
        lcd.print(buf);
        
        led1 = !led1;

        ws.write_offsets(px.getBuf(), idx, idx, idx);
        idx++;
        if (idx >= WS2812_BUF) {
            idx = 0;
        }

        wait(0.5);
    }
}
