#include "mbed.h"
#include "EthernetInterface.h"

int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("httpbin.org", 80);
    
    char http_cmd[] = "GET /get?helloworld HTTP/1.0\r\n\r\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
}

// override the default weak function to provide a specific mac address
extern "C" void mbed_mac_address(char *mac)
{
    mac[0] = 0x01;
    mac[1] = 0x23;
    mac[2] = 0x45;
    mac[3] = 0x67;
    mac[4] = 0x89;
    mac[5] = 0xAB;
};
