/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet.zou@gmail.com
  2014-02-12

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"

/******Pins definitions*************/
#if defined(TARGET_LPC11U24)    //SEEEDUINO_ARCH
    #define RELAY_1     P1_5
    #define RELAY_2     P1_25
    #define RELAY_3     P1_24
    #define RELAY_4     P1_18
#elif defined(TARGET_LPC1768)   //SEEEDUINO_ARCH_PRO
    #define RELAY_1     P2_5
    #define RELAY_2     P2_4
    #define RELAY_3     P2_3
    #define RELAY_4     P2_2
#else   //please redefine the follow pins.
    #define RELAY_1
    #define RELAY_2
    #define RELAY_3
    #define RELAY_4
#endif

DigitalOut relayCtrl(RELAY_2); //we use Relay2

int main() {
    while(1) {
        relayCtrl = 1;
        wait(2);
        relayCtrl = 0;
        wait(2);
    }
}
