/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet.zou@gmail.com
  2014-02-11

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "MotorDriver.h"

/******Pins definitions*************/
#if defined(TARGET_LPC11U24)    //SEEEDUINO_ARCH
    #define MOTORSHIELD_IN1     P1_26
    #define MOTORSHIELD_IN2     P1_29
    #define MOTORSHIELD_IN3     P0_8
    #define MOTORSHIELD_IN4     P0_9
    #define SPEEDPIN_A          P1_27
    #define SPEEDPIN_B          P0_2
#elif defined(TARGET_LPC1768)   //SEEEDUINO_ARCH_PRO
    #define MOTORSHIELD_IN1     P0_0
    #define MOTORSHIELD_IN2     P0_9
    #define MOTORSHIELD_IN3     P0_8
    #define MOTORSHIELD_IN4     P0_7
    #define SPEEDPIN_A          P0_1
    #define SPEEDPIN_B          P0_6
#else //please redefine the follow pins.
    #define MOTORSHIELD_IN1     
    #define MOTORSHIELD_IN2     
    #define MOTORSHIELD_IN3     
    #define MOTORSHIELD_IN4     
    #define SPEEDPIN_A          
    #define SPEEDPIN_B          
#endif

MotorDriver motorDriver(MOTORSHIELD_IN1,MOTORSHIELD_IN2,MOTORSHIELD_IN3,MOTORSHIELD_IN4,SPEEDPIN_A,SPEEDPIN_B);

int main(){
    /*Configure the motor A to control the wheel at the left side.*/
    /*Configure the motor B to control the wheel at the right side.*/
    motorDriver.init();
    motorDriver.setSpeed(90,MOTORB);
    motorDriver.setSpeed(90,MOTORA);
    while(1){
        motorDriver.goForward();
        wait(5);
        motorDriver.stop();
        wait(5);
        motorDriver.goBackward();
        wait(5);
        motorDriver.stop();
        wait(5);
        motorDriver.goLeft();
        wait(5);
        motorDriver.stop();
        wait(5);
        motorDriver.goRight();
        wait(5);
        motorDriver.stop();
        wait(5);  
    }   
}