#include "mbed.h"
#include "GPRSInterface.h"
#include "HTTPClient.h"

#ifdef TARGET_ARCH_GPRS
#include "USBSerial.h"
#define LOG(args...)    pc.printf(args)
USBSerial pc;
#else
#define LOG(args...)    pc.printf(args)
Serial pc(USBTX, USBRX);
#endif

#define TEST_HTTP_GET       1
#define TEST_HTTP_POST      1
#define TEST_HTTP_PUT       1
#define TEST_HTTP_DELETE    1

#define PIN_TX              P1_27
#define PIN_RX              P1_26


GPRSInterface gprs(PIN_TX, PIN_RX, 115200, "uninet", NULL, NULL);
HTTPClient http;
char str[1024];

#ifdef TARGET_ARCH_GPRS
DigitalOut power(P1_2);
DigitalOut powerKey(P1_7);

/* power pin: low enable
     ___
        |___

   powerKey pin: you can also power up by long press the powerKey.

        ___
    ___|   |___

*/
void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);

    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);
}
#endif

int main()
{
#ifdef TARGET_ARCH_GPRS
    gprsPowerUp();
#endif
    gprs.init();

    while(false == gprs.connect()) {
        LOG("gprs connect error\n");
        wait(2);
    }

    // successful DHCP
    LOG("IP Address is %s\n", gprs.getIPAddress());

    int ret;
    HTTPMap map;
    HTTPText inText(str, 1024);
    HTTPText outText(str);

#if TEST_HTTP_GET
    //GET data
    LOG("\nTrying to fetch page...\n");
    ret = http.get("http://developer.mbed.org/media/uploads/mbed_official/hello.txt", str, 1024);
    if (!ret) {
        LOG("Page fetched successfully - read %d characters\n", strlen(str));
        LOG("Result: %s\n", str);
    } else {
        LOG("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
#endif

#if TEST_HTTP_POST
    //POST data
    map.put("Hello", "World");
    map.put("test", "1234");
    LOG("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret) {
        LOG("Executed POST successfully\n");
    } else {
        LOG("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
#endif

#if TEST_HTTP_PUT
    //PUT data
    strcpy(str, "This is a PUT test!");
    LOG("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret) {
        LOG("Executed PUT successfully - read %d characters\n", strlen(str));
        LOG("Result: %s\n", str);
    } else {
        LOG("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
#endif

#if TEST_HTTP_DELETE
    //DELETE data
    LOG("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret) {
        LOG("Executed DELETE successfully\n");
    } else {
        LOG("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
#endif

    gprs.disconnect();

    return 0;
}
