#include "mbed.h"

AnalogIn gsr(A0);
DigitalOut buzzer(D5);

float gsrValue = 0;
float baseline = 0;
int on = 1, off = 0;

// calculate baseline to compare against
void Get_Baseline(void)
{
    double sum = 0;
    buzzer = off;
    wait(1);
    for(int i=0; i<500; i++) {
        gsrValue = gsr;
        sum += gsrValue;
        wait(0.005);
    }
    baseline = sum/500;
    printf("baseline = %f\n\r", baseline);
}

// main loop, compare against baseline
// sound buzzer if a >5% change happens
int main()
{
    float delta;
    Get_Baseline();
    while(1) {
        gsrValue = gsr;
        printf("gsrValue = %f\n\r",gsrValue);
        delta = baseline - gsrValue;
        if(abs(delta) > 0.05) { // check for > 5% change
            gsrValue = gsr;
            delta = baseline - gsrValue;
            if(abs(delta) > 0.05) { // double check
                buzzer = on;
                printf("YES!\n\r");
                wait(3);
                buzzer = off;
                wait(1);
            }
        }
    }
}
