#include "mbed.h"
#include "pitches.h"

DigitalOut myled(LED1);

PwmOut buzzer(P1_14);  // Buzzer connected to UART Grove connector (PWM output)

int frequency[] = {NOTE_C4, NOTE_G3,NOTE_G3, NOTE_A3, NOTE_G3, 1, NOTE_B3, NOTE_C4};
int beat[] = {4, 8, 8, 4,4,4,4,4 };

int main() {
    for (int i = 0; i < (sizeof(frequency) / sizeof(int)); i++) {
        buzzer.period(1.0 / frequency[i]);
        buzzer.write(0.5);
        wait(1.0 / beat[i]);
        buzzer.write(0);
        wait(0.05);
    }
    
    while(1) {
        myled = !myled;
        wait(1);
    }
}
