#include "mbed.h"
#include "DigitDisplay.h"

DigitDisplay display(P1_14, P1_13); // 4-Digit Display connected to UART Grove connector
DigitalOut   led(LED1);

Ticker ticker;
volatile uint8_t second = 0;
volatile uint8_t minute = 0;
volatile uint8_t hour = 12;
volatile bool colon_enable = false;

void tick()
{
    colon_enable = !colon_enable;
    display.setColon(colon_enable);
    
    if (colon_enable) {
        second++;
        if (second >= 60) {
            second = 0;
            minute++;
            if (minute >= 60) {
                minute = 0;
                hour++;
                if (hour >= 24) {
                    hour = 0;
                }
            }
            
            display.write(hour * 100 + minute);
        }
    }
}

int main() {
    display.write(hour * 100 + minute);
    ticker.attach(tick, 0.5);
    while(1) {
        led = !led;
        wait(0.5);
    }
}
