#include "mbed.h"
#include "GPRSInterface.h"
#include "xively.h"
#include "xi_err.h"

#define PIN_TX          P0_19
#define PIN_RX          P0_18
#define XI_FEED_ID      571464242 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY      "niUYuSJkjqyzPFwnWqpApm7lLNv8fInUD6ijAoRrikqKFWbg" // set Xively API key (double-quoted string)

AnalogIn soundSensor(P0_11);
GPRSInterface gprs(PIN_TX,PIN_RX,19200,"cmnet",NULL,NULL);

int main()
{
    gprs.init(); //Use DHCP
    // attempt DHCP
    while(false == gprs.connect()) {
        wait(2);
        //printf("gprs connect error\n");
    }
    // successful DHCP
    //printf("IP Address is %s\n", gprs.getIPAddress());

    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );

    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 1;

    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* sound_datastream = &feed.datastreams[0];
    strcpy( sound_datastream->datastream_id, "Sound" );
    xi_datapoint_t* current_sound = &sound_datastream->datapoints[0];

    // create the cosm library context
    xi_context_t* xi_context = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL ) {
        return -1;
    }

    while(1) {
        xi_set_value_f32(current_sound, soundSensor.read());
        xi_feed_update( xi_context, &feed );
        //printf("update success\n");
        wait( 10 );
    }
}