/*
  main.cpp
  2013 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-18

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "GPRSInterface.h"
#include "mbed.h"

#if defined(TARGET_LPC11U24)//SEEEDUINO_ARCH
#define PIN_TX        P1_22
#define PIN_RX        P1_21
#elif defined(TARGET_LPC1768)//SEEEDUINO_ARCH_PRO
#define PIN_TX        P0_0
#define PIN_RX        P0_1
#else //please redefine the following pins
#define PIN_TX
#define PIN_RX
#endif

GPRSInterface gprsInterface(PIN_TX,PIN_RX,19200,"cmnet",NULL,NULL);

int main(void)
{
    // use DHCP
    gprsInterface.init();

    // attempt DHCP
    while(false == gprsInterface.connect()) {
        wait(2);
    }

    // successful DHCP
    printf("IP Address is %s\n", gprsInterface.getIPAddress());

    TCPSocketConnection sock;
    if(false == sock.connect("mbed.org", 80)) {
        return -1;
    }

    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\r\n\r\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[512];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Recv %d bytes:\n%s\n",ret,buffer);
    }
    sock.close();
    gprsInterface.disconnect();

    return 0;
}
