/*
  main.cpp
  2013 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-18

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "WIZ820ioInterface.h"
#include "mbed.h"

#if defined(TARGET_LPC11U24)    //SEEEDUINO_ARCH
    #define PIN_MOSI        P1_22
    #define PIN_MISO        P1_21
    #define PIN_SCLK        P1_20
    #define PIN_CS          P0_2
#elif defined(TARGET_LPC1768)   //SEEEDUINO_ARCH_PRO
    #define PIN_MOSI        P0_18
    #define PIN_MISO        P0_17
    #define PIN_SCLK        P0_15
    #define PIN_CS          P0_6
#else //please redefine the following pins
    #define PIN_MOSI
    #define PIN_MISO
    #define PIN_SCLK
    #define PIN_CS
#endif

WIZ820ioInterface eth(PIN_MOSI,PIN_MISO,PIN_SCLK,PIN_CS,NC);//mosi,miso,sclk,cs,reset;

int main(void)
{
    // use DHCP
    eth.init();

    // attempt DHCP
    eth.connect();

    // successful DHCP
    printf("IP Address is %s\n", eth.getIPAddress());

    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);

    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }

    sock.close();

    eth.disconnect();

    return 0;
}
