/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-4-29

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "USBSerial.h"
#include "DS1337.h"

USBSerial pc;
DS1337 RTC_DS1337(P0_5,P0_4);
typedef struct{
    int hour;
    int minutes;
    int second;
    int year;
    int month;
    int day;
    int week;
}TIME_S;
 
TIME_S time_now;
 
void time_refresh()
{
    RTC_DS1337.readTime();
    time_now.hour      = RTC_DS1337.getHours();
    time_now.minutes   = RTC_DS1337.getMinutes();
    time_now.second    = RTC_DS1337.getSeconds();
    time_now.year      = RTC_DS1337.getYears();
    time_now.month     = RTC_DS1337.getMonths();
    time_now.day       = RTC_DS1337.getDays();
    time_now.week      = RTC_DS1337.getDayOfWeek(); 
}
 
void setTime()
{
    RTC_DS1337.setSeconds(50);
    RTC_DS1337.setMinutes(35);
    RTC_DS1337.setHours(17);
    RTC_DS1337.setDays(27);
    RTC_DS1337.setDayOfWeek(4);
    RTC_DS1337.setMonths(3);
    RTC_DS1337.setYears(2014);
    RTC_DS1337.setTime();
}

void show_time()
{
    pc.printf("Date: %d/%d/%d\r\n",time_now.year,time_now.month,time_now.day);
    pc.printf("Time: %d:%d:%d\r\n\r\n",time_now.hour,time_now.minutes,time_now.second);
}

int main() {
    setTime();
    while(1) {
        time_refresh();
        show_time();
        wait(10);
    }
}
