/*
  main.cpp
  2013 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2013-7-21

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mbed.h"
#include "string.h"
#include "gprs.h"
#include "USBSerial.h"

#define SEND_SMS_TEST           0
#define CALL_UP_TEST            0
#define ANSWER_TEST             0
#define READ_SMS_TEST           0

#define PHONE_NUMBER            "13925257382"
#define PIN_PWR                 P1_2    //power up gprs module
#define PIN_PWR_KEY             P1_7
#define PIN_TX                  P1_27   //Serial tx pin
#define PIN_RX                  P1_26   //Serial rx pin

USBSerial pc(0x1f00, 0x2012, 0x0001, false);
DigitalOut power(PIN_PWR);
DigitalOut powerKey(PIN_PWR_KEY);
GPRS  gprsTest(PIN_TX, PIN_RX, 115200, PHONE_NUMBER);

// Called by ISR
void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};

    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }

    gprsTest.gprsSerial.baud(baud);
    gprsTest.gprsSerial.format(bits, parityTable[parity], stop);
}

/* power pin: low enable
     ___
        |___

   powerKey pin: you can also power up by long press the powerKey.

        ___
    ___|   |___

*/
void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);

    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);
}

void messageHandle(void)
{
    __disable_irq();
    int messageType = gprsTest.loopHandle();
    if(MESSAGE_RING == messageType) {
        gprsTest.answer();
    } else if(MESSAGE_SMS == messageType) {
        char smsMessage[SMS_MAX_LENGTH];
        gprsTest.getSMS(smsMessage);
        pc.printf("we get SMS:%s",smsMessage);
    }
    __enable_irq();
}

int main(void)
{
    pc.attach(settingsChanged);
    gprsPowerUp();
    wait(10);

    while(0 != gprsTest.init()) {
        pc.printf("\ngprs init error\n");
        wait(2);
    }

#if SEND_SMS_TEST
    pc.printf("send SMS test\n");
    gprsTest.sendSMS(PHONE_NUMBER,"hello world"); //define phone number and text
#endif

#if CALL_UP_TEST
    pc.printf("call up test\n");
    gprsTest.callUp(PHONE_NUMBER);
#endif

#if ANSWER_TEST || READ_SMS_TEST
    pc.printf("Please give a call or send a message\n");
    gprsTest.gprsSerial.attach(&messageHandle);
#endif
    while(1) {
        wait(1);
    }
    return 0;
}