
/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "GPRSInterface.h"
#include "PubSubClient.h"
#include "USBSerial.h"

#define NETWORK_APN     ""

#define PIN_PWR                 P1_2    //power up gprs module
#define PIN_PWR_KEY             P1_7
#define PIN_TX                  P1_27   //Serial tx pin
#define PIN_RX                  P1_26   //Serial rx pin


DigitalOut power(PIN_PWR);
DigitalOut powerKey(PIN_PWR_KEY);

USBSerial pc;

//Serial uart(USBTX, USBRX);
GPRSInterface eth(PIN_TX, PIN_RX, NETWORK_APN, "", "");

char* serverIpAddr = "opensensors.io";  /*Sever ip address*/
int port = 1883; /*Sever Port*/
void callback(char* topic, char* payload, unsigned int len); /*Callback function prototype*/
PubSubClient mqtt(serverIpAddr, port, callback);

void callback(char* topic, char* payload, unsigned int len)
{
    pc.printf("Topic:%s\r\n", topic);
    pc.printf("Payload:%s\r\n\r\n", payload);

    //Send incoming payloads back to topic "/mbed".
    mqtt.publish("/users/yihui/message", payload, len);
}

void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);

    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);
}

int main()
{
    pc.printf("Powering up!");
    gprsPowerUp();
    wait(10);
    
    // Initialize the interface.
    int s = eth.init();
    if (s != NULL) {
        pc.printf(">>> Could not initialise. Halting!\n");
        exit(0);
    }

    pc.printf(">>> Get IP address...\n");
    while (1) {
        s = eth.connect(); // Connect to network

        if (s == false || s < 0) {
            pc.printf(">>> Could not connect to network. Retrying!\n");
            wait(3);
        } else {
            break;
        }
    }
    pc.printf(">>> Got IP address: %s\n", eth.getIPAddress());
    
    char clientID[] = "1095";   /*Client nanme show for MQTT server*/
    char user[] = "yihui";
    char password[] = "cLkFPjQa";
    char pub_topic[] = "/users/yihui/test"; 
    char sub_topic[] = "/users/yihui/test";
    
    
mqtt_connect:
    while (!mqtt.connect(clientID, user, password)){
        pc.printf("\r\nConnect to server failed ..\r\n");
        pc.printf("wait 3 seconds. Retrying\n");
        wait(3);
    }
    pc.printf("\r\nConnect to server sucessed ..\r\n");
    
    mqtt.publish(pub_topic, "Hello from Arch GPRS");
    mqtt.subscribe(sub_topic);
    
    while(1) {
        if (!mqtt.loop()) {
            goto mqtt_connect;
        }
    }
    
    // Disconnect from network
    //eth.disconnect();
    
    return 0;
}
