/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-4-28

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mbed.h"
#include "GPRSInterface.h"
#include "USBSerial.h"
#include "xively.h"
#include "xi_err.h"

#define PIN_PWR                 P1_2    //power up gprs module
#define PIN_PWR_KEY             P1_7
#define PIN_TX                  P1_27
#define PIN_RX                  P1_26
#define XI_FEED_ID              571464242 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY              "niUYuSJkjqyzPFwnWqpApm7lLNv8fInUD6ijAoRrikqKFWbg" // set Xively API key (double-quoted string)

AnalogIn soundSensor(P0_12);
GPRSInterface gprs(PIN_TX,PIN_RX,115200,"cmnet",NULL,NULL);
USBSerial pc(0x1f00, 0x2012, 0x0001, false);
DigitalOut power(PIN_PWR);
DigitalOut powerKey(PIN_PWR_KEY);

/* power pin: low enable
     ___
        |___

   powerKey pin: you can also power up by long press the powerKey.

        ___
    ___|   |___

*/
void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);

    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);
}
// Called by ISR
void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};

    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }

    gprs.serialModem.baud(baud);
    gprs.serialModem.format(bits, parityTable[parity], stop);
}

int main()
{
    pc.attach(settingsChanged);
    gprsPowerUp();
    wait(10);

    gprs.init(); //Use DHCP
    // attempt DHCP
    while(false == gprs.connect()) {
        wait(2);
        pc.printf("gprs connect error\n");
    }
    // successful DHCP
    pc.printf("IP Address is %s\n", gprs.getIPAddress());

    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );

    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 1;

    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* sound_datastream = &feed.datastreams[0];
    strcpy( sound_datastream->datastream_id, "Sound" );
    xi_datapoint_t* current_sound = &sound_datastream->datapoints[0];

    // create the cosm library context
    xi_context_t* xi_context = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL ) {
        return -1;
    }
    while(1) {
        float val = 100*soundSensor.read();
        pc.printf("val = %f\n",val);
        xi_set_value_f32(current_sound, val);
        xi_feed_update( xi_context, &feed );
        wait( 10 );
    }
}