/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-10

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "SDFileSystem.h"

/*
  SEEED ARCH PRO and  SEEED ARCH with Seeed SD Card Shield V4.0
  
  Digital Pin 4 which is P1_18 on Seeeduino ARCH and P2_2 on
  Seeeduino ARCH Pro has been used as PIN_CS and should not be
  used any more! pin match is as follow. Have fun!
*/

#if defined(TARGET_LPC11U24)    //SEEEDUINO_ARCH
    #define PIN_MOSI        P1_22
    #define PIN_MISO        P1_21
    #define PIN_SCK         P1_20
    //#define PIN_CS        P1_23
    #define PIN_CS          P1_18
#elif defined(TARGET_LPC1768)   //SEEEDUINO_ARCH_PRO
    #define PIN_MOSI        P0_18
    #define PIN_MISO        P0_17
    #define PIN_SCK         P0_15
    //#define PIN_CS        P0_16
    #define PIN_CS          P2_2
#else //please redefine the following pins.
    #define PIN_MOSI       
    #define PIN_MISO       
    #define PIN_SCK      
    #define PIN_CS      
#endif

SDFileSystem sd(PIN_MOSI, PIN_MISO, PIN_SCK, PIN_CS, "sd"); // MOSI, MISO, SCK, CS
Serial pc(USBTX, USBRX);

int main()
{
    pc.printf("Hello World!\n");

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp);

    pc.printf("Goodbye World!\n");
}
