

/*    
 * A library for MAX31855 
 *   
 * Copyright (c) 2015 Seeed Technology Limited.  
 * Author      : Yihui Xiong
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef __MAX31855_H__
#define __MAX31855_H__

#include "mbed.h"

class MAX31855
{
    public:
        typedef enum {
            THERMOCOUPLE_T = 0,
            INTERNAL_T     = 1,
        } temperature_type_t;
        
    public:
        MAX31855(SPI& _spi, PinName _ncs);
        float read(temperature_type_t type = THERMOCOUPLE_T);

  
  private:
    SPI& spi;
    DigitalOut ncs;
    float thermocoupleT;
    float internalT;
    uint32_t lastReadTime;
};

#endif // __MAX31855_H__
