/*
  SerialLCD.h - Serial LCD driver Library
  
  2010-2013 Copyright (c) Seeed Technology Inc (www.seeedstudio.com)  
  Authors: Jimbo.We, Visweswara R and Frankie.Chu  (Orignially written for Seeeduino)
  
  This library can be used under Apache License 2.0 or MIT License.
*/

#ifndef __SERIAL_LCD_H__
#define __SERIAL_LCD_H__

#include "mbed.h"

/** Grove Serial LCD libray. The Serial LCD is connected to mbed through a UART port.
 */

class SerialLCD : public Serial {
public:

    SerialLCD(PinName, PinName);
    void begin();
    void clear();
    void home();

    void noDisplay();
    void display();
    void noBlink();
    void blink();
    void noCursor();
    void cursor();
    void scrollDisplayLeft();
    void scrollDisplayRight();
    void leftToRight();
    void rightToLeft();
    void autoscroll();
    void noAutoscroll();

    void setCursor(uint8_t, uint8_t);
    void noPower(void);
    void Power(void);
    void noBacklight(void);
    void backlight(void);
    void print(uint8_t b);
    void print(const char[]);

};

#endif
