
#include "udriver.h"
#include "mbed.h"
#include "color_pixels.h"

int color_led_strip_init(void *obj, void *params)
{
    int pin = *(int *)params;
    int num = *((int *)params + 2);
    if (num == 0) {
        num = 30;
    }
    ColorPixels *ptr = new ColorPixels(pin, num);
    *((ColorPixels **)obj) = ptr;
    
    ptr->set_all_color(0, 0, 125);
    
    return 0;
}
    

int color_led_strip_read(void *obj, void *data)
{
    return 0;
}

int color_led_strip_write(void *obj, void *data)
{
    ColorPixels *pixels = *(ColorPixels **)obj;
    float *params = (float *)data;
    uint8_t red   = params[0];
    uint8_t green = params[1];
    uint8_t blue  = params[2];
    uint8_t mode  = params[3];
    
    // printf("r: %d, g: %d, b: %d, mode: %d\n", red, green, blue, mode);
    if (mode == 0) {
        pixels->set_all_color(red, green, blue);
    } else if (mode == 1) {
        pixels->rainbow(red, green, blue);
    }
    
    return 0;
}

int color_led_strip_fini(void *obj)
{
    ColorPixels *ptr = *(ColorPixels **)obj;
    delete ptr;
    
    return 0;
}

driver_t color_led_strip_driver = 
{
    .init  = color_led_strip_init,
    .read  = color_led_strip_read,
    .write = color_led_strip_write,
    .fini  = color_led_strip_fini,
    
    .d     = 4,
};
