
#ifndef __UDRIVER_H__
#define __UDRIVER_H__

#include <stdint.h>

typedef struct _driver_t        driver_t;
typedef enum _data_type_t       data_type_t;

struct _driver_t {
    int     (*init)(void *obj, void *params);
    int     (*read)(void *obj, void *data);
    int     (*write)(void *obj, void *data);
    int     (*fini)(void *obj);
    
    uint8_t     d;     // dimention
    data_type_t *type;
    
    uint16_t    id;
    char        *name;
};

enum _data_type_t {
    DATA_TYPE_PENCENTAGE        = 1,
    DATA_TYPE_TEMPERATURE       = 2,
    DATA_TYPE_HUMIDITY          = 3,
    DATA_TYPE_LIGHT             = 4,
    DATA_TYPE_RED               = 5,
    DATA_TYPE_GREEN             = 6,
    DATA_TYPE_BLUE              = 7,
    DATA_TYPE_ACCELERATION      = 8,
    DATA_TYPE_ACCELERATION_X    = 9,
    DATA_TYPE_ACCELERATION_Y    = 10,
    DATA_TYPE_ACCELERATION_Z    = 11,
    DATA_TYPE_ROTATION          = 12,
    DATA_TYPE_ROTATION_X        = 13,
    DATA_TYPE_ROTATION_Y        = 14,
    DATA_TYPE_ROTATION_Z        = 15,
};
    

#endif // __UDRIVER_H__
