
#include "udriver.h"
#include "mbed.h"

int relay_init(void *obj, void *params)
{
    int pin = *(int *)params;
    DigitalInOut *ptr = new DigitalInOut((PinName)pin);
    *((DigitalInOut **)obj) = ptr;
    ptr->input();
    
    return 0;
}
    

int relay_read(void *obj, void *data)
{
    DigitalInOut *in = *(DigitalInOut **)obj;
    
    in->input();
    int value = in->read();
    *(float *)data = value;
    
    return 0;
}

int relay_write(void *obj, void *data)
{
    DigitalInOut *out = *(DigitalInOut **)obj;
    uint32_t value = *(float *)data;
    out->output();
    out->write(value);
    
    // printf("relay: %d\n", value);
    
    return 0;
}

int relay_fini(void *obj)
{
    DigitalInOut *ptr = *(DigitalInOut **)obj;
    delete ptr;
    
    return 0;
}

driver_t relay_driver = 
{
    .init  = relay_init,
    .read  = relay_read,
    .write = relay_write,
    .fini  = relay_fini,
};
