
#include "udriver.h"
#include "mbed.h"

int analog_sensor_init(void *obj, void *params)
{
    int pin = *(int *)params;
    AnalogIn *probe = new AnalogIn((PinName)pin);
    *((AnalogIn **)obj) = probe;
    
    return 0;
}
    

int analog_sensor_read(void *obj, void *data)
{
    AnalogIn *probe = *(AnalogIn **)obj;
    
    *(float *)data = probe->read() * 100;
    
    return 0;
}

int analog_sensor_write(void *obj, void *data)
{
    return 0;
}

int analog_sensor_fini(void *obj)
{
    AnalogIn *ptr = *(AnalogIn **)obj;
    delete ptr;
    
    return 0;
}

driver_t analog_sensor_driver = 
{
    .init  = analog_sensor_init,
    .read  = analog_sensor_read,
    .write = analog_sensor_write,
    .fini  = analog_sensor_fini,
    
    .d     = 1,
};
