
#include "udriver.h"
#include "mbed.h"

uint8_t time_sensor_second = 0;


void time_sensor_tick(void)
{
    time_sensor_second++;
    if (time_sensor_second >= 60) {
        time_sensor_second = 0;
    }
}

int time_sensor_init(void *obj, void *params)
{
    Ticker *ticker = new Ticker();
    *((Ticker **)obj) = ticker;
    
    ticker->attach(time_sensor_tick, 1);
    
    return 0;
}
    

int time_sensor_read(void *obj, void *data)
{
    *(float *)data = time_sensor_second;
    
    return 0;
}

int time_sensor_write(void *obj, void *data)
{
    return 0;
}

int time_sensor_fini(void *obj)
{
    Ticker *ptr = *(Ticker **)obj;
    ptr->detach();
    delete ptr;
    
    return 0;
}

driver_t time_sensor_driver = 
{
    .init  = time_sensor_init,
    .read  = time_sensor_read,
    .write = time_sensor_write,
    .fini  = time_sensor_fini,
    
    .d     = 1,
};
