
#include "udriver.h"
#include "mbed.h"

int led_init(void *obj, void *params)
{
    int pin = *(int *)params;
    *((PwmOut **)obj) = new PwmOut((PinName)pin);
    
    return 0;
}
    

int led_read(void *obj, void *data)
{
    PwmOut *output = *(PwmOut **)obj;
    
    *(float *)data = output->read();
    
    return 0;
}

int led_write(void *obj, void *data)
{
    PwmOut *pwm = *(PwmOut **)obj;
    float pulse_width = *(float *)data;
    float period   = *((float *)data + 1);
    
    pwm->write(pulse_width);
    if (0 != period) {
        pwm->period(period);
    }
    
    // printf("pulse: %f, period: %f\n", pulse_width, period);
    
    return 0;
}

int led_fini(void *obj)
{
    PwmOut *ptr = *(PwmOut **)obj;
    delete ptr;
    
    return 0;
}

driver_t led_driver = 
{
    led_init,
    led_read,
    led_write,
    led_fini,
    
    2,
};
