
#include "udriver.h"
#include "mbed.h"

int temperature_sensor_init(void *obj, void *params)
{
    int pin = *(int *)params;
    *(AnalogIn **)obj = new AnalogIn((PinName)pin);
    
    return 0;
}
    

int temperature_sensor_read(void *obj, void *data)
{
    const uint32_t beta = 3975;
    float a;
    float temperature;
    float resistance;
    AnalogIn *probe = *(AnalogIn **)obj;
    
    a = probe->read();
    
    /* Calculate the resistance of the thermistor from analog votage read. */
    resistance = (float) 10000.0 * ((1 / a) - 1);
    
    /* Convert the resistance to temperature using Steinhart's Hart equation */
    temperature = (1/((log(resistance/10000.0)/beta) + (1.0/298.15)))-273.15; 
    
    *(float *)data = temperature;
    
    return 0;
}

int temperature_sensor_write(void *obj, void *data)
{
    return 0;
}

int temperature_sensor_fini(void *obj)
{
    AnalogIn *ptr = *(AnalogIn **)obj;
    delete ptr;
    
    return 0;
}

driver_t temperature_sensor_driver = 
{
    .init  = temperature_sensor_init,
    .read  = temperature_sensor_read,
    .write = temperature_sensor_write,
    .fini  = temperature_sensor_fini,
    
    .d     = 1,
};
