

#include "udriver.h"
#include "mbed.h"
#include "BLEDevice.h"
#include "UARTService.h"
#include "color_pixels.h"

#define LOG(...)       // { printf(__VA_ARGS__); }

#define MAX_INIT_DATA           4
#define MAX_SENOSR_DIMENSION    9
#define MAX_ACTUATOR_DATA_BUF   16
#define MAX_EQUATION_NUMBER     2
#define MAX_TASK_NUMBER         8


typedef struct {
    uint8_t     d;      // dimension
    uint8_t     op;     // operator
    uint8_t     extra;
    float       value;
} equation_t;
    
typedef struct {
    equation_t  equation_list[MAX_EQUATION_NUMBER];
    uint8_t     output[MAX_ACTUATOR_DATA_BUF];
} task_t;
    


extern UARTService *uartServicePtr;
extern volatile bool ble_is_connected;

extern driver_t analog_sensor_driver;
extern driver_t temperature_sensor_driver;
extern driver_t time_sensor_driver;

extern driver_t relay_driver;
extern driver_t led_driver;
extern driver_t color_led_strip_driver;

driver_t *sensor_list[] = {
    &analog_sensor_driver,
    &temperature_sensor_driver,
    &time_sensor_driver,
};

driver_t *actuator_list[] = {
    &relay_driver,
    &led_driver,
    &color_led_strip_driver
};


driver_t *sensor;
driver_t *actuator;
int sensor_index = 0;
int actuator_index = 0;
void *sensor_object;
void *actuator_object;
float sensor_data[MAX_SENOSR_DIMENSION] = {0,};
float actuator_data[MAX_ACTUATOR_DATA_BUF] = {0,};

int sensor_init_data[MAX_INIT_DATA] = {0, };
int actuator_init_data[MAX_INIT_DATA] = {0, };

task_t task_list[MAX_TASK_NUMBER];
uint32_t task_mask = 0;

bool equation_test(equation_t *equation, float *data)
{
    bool result = false;
    if (0x01 == equation->op) {         // >
        result = data[equation->d] > equation->value;
    } else if (0x02 == equation->op) {  // <
        result = data[equation->d] < equation->value;
    } else if (0x03 == equation->op) {  // =
        result = data[equation->d] == equation->value;
    }
    
    return true;
}

void node_init()
{
    sensor_index = 0;
    sensor = sensor_list[sensor_index];
    sensor_init_data[0] = p1;
    sensor_init_data[1] = p2;
    sensor->init(&sensor_object, sensor_init_data);

    actuator_index = 2;
    actuator = actuator_list[actuator_index];
    actuator_init_data[0] = p3;
    actuator_init_data[1] = p4;
    actuator_init_data[2] = 30;
    actuator->init(&actuator_object, actuator_init_data);
}

void node_tick()
{
    sensor->read(&sensor_object, sensor_data);


    for (int d = 0; d < sensor->d; d++) {
        float value = sensor_data[d];

        if (ble_is_connected) {
            uartServicePtr->printf("i %d %f\n", d, value);
        }
    }
    
    uint32_t mask = task_mask;
    int task_index = 0;
    while (mask) {
        if (mask & 1) {
            task_t *task = task_list + task_index;
            bool result = false;
            for (int i = 0; i < MAX_EQUATION_NUMBER; i++) {
                equation_t *equation = task->equation_list + i;
                if (0 == equation->extra) {
                    break;
                }
                
                bool equation_result = equation_test(equation, sensor_data);
                if ('&' == equation->extra) {
                    result = result && equation_result;
                } else {
                    result = result || equation;
                }
            }
            
            if (result) {
                actuator->write(&actuator_object, task->output);
            }
        }
        
        task_index++;
        mask >>= 1;
    }
}

void node_parse(int argc, char *argv[])
{
    if (0 == strcmp(argv[0], "s")) {
        int param1 = atoi(argv[1]);
        if (param1 != sensor_index) {
            sensor_index = param1;
            sensor->fini(&sensor_object);
            sensor = sensor_list[param1];
            sensor->init(&sensor_object, sensor_init_data);

            task_mask = 0;
        }

        LOG("select sensor [%d]\n", sensor_index);
    } else if (0 == strcmp(argv[0], "a")) {
        int param1 = atoi(argv[1]);
        if (param1 != actuator_index) {
            actuator_index = param1;
            actuator->fini(&actuator_object);
            actuator = actuator_list[param1];
            actuator->init(&actuator_object, actuator_init_data);
            
            task_mask = 0;
        }

        LOG("select actuator [%d]\n", actuator_index);


    } else if (0 == strcmp(argv[0], "o")) {

        int n = argc - 1;
        if (n > 8) {
            n = 8;
        }


        LOG("set output:");
        for (int i = 0; i < 8; i++) {
            if (i < n) {
                float value = atof(argv[i + 1]);
                actuator_data[i] = value;
                LOG(" %f", value);
            } else {
                actuator_data[i] = 0;
            }
        }

        LOG("\n");

        actuator->write(&actuator_object, actuator_data);
    }

}
