/*
  main.cpp
  2013 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-08

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mbed.h"
#include "gprs.h"

#if defined(TARGET_LPC11U24)    //SEEEDUINO_ARCH
    #define GPRS_TX_PIN             P0_19
    #define GPRS_RX_PIN             P0_18
#elif defined(TARGET_LPC1768)   //SEEEDUINO_ARCH_PRO
    #define GPRS_TX_PIN             P4_28
    #define GPRS_RX_PIN             P4_29
#else //please redefine the following pins
    #define GPRS_TX_PIN             
    #define GPRS_RX_PIN             
#endif

#define SEND_SMS_TEST           0
#define CALL_UP_TEST            0
#define ANSWER_TEST             0
#define READ_SMS_TEST           0

#define BAUD_RATE               19200 // Baud rate of GPRS Shield 
#define PHONE_NUMBER            "159****4951"

GPRS  gprsTest(GPRS_TX_PIN, GPRS_RX_PIN, BAUD_RATE, PHONE_NUMBER);

void messageHandle(void)
{        
     __disable_irq();
    int messageType = gprsTest.loopHandle();
    if(MESSAGE_RING == messageType) {
        gprsTest.answer();
    } else if(MESSAGE_SMS == messageType) {
        char smsMessage[SMS_MAX_LENGTH];
        gprsTest.getSMS(smsMessage);
    }
    __enable_irq();
}

int main(void)
{
    while(0 != gprsTest.init()) {
        wait(2);
    }

#if SEND_SMS_TEST
    gprsTest.sendSMS(PHONE_NUMBER,"hello world"); //define phone number and text
#endif

#if CALL_UP_TEST
    gprsTest.callUp(PHONE_NUMBER);
#endif

#if ANSWER_TEST || READ_SMS_TEST
    gprsTest.gprsSerial.attach(&messageHandle);
#endif
    while(1){wait(1);}
    return 0;
}



