/*
  modem.h
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-2-24

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __MODEM_H__
#define __MODEM_H__

#if defined(TARGET_LPC11UXX) || defined (TARGET_LPC176X)
#include "BufferedSerial.h"
#define INTERFACE_BASE      BufferedSerial
#else
#include "mbed.h"
#define INTERFACE_BASE      Serial
#endif

#define DEFAULT_TIMEOUT_MS   	30000


/** Modem class.
 *  Used for Modem communication. attention that Modem module communicate with MCU in serial protocol
 */
class Modem : public INTERFACE_BASE
{

public:
    /**	Create Modem Instance
     *  @param tx	uart transmit pin to communicate with Modem
     *  @param rx	uart receive pin to communicate with Modem
     */
    Modem(PinName tx, PinName rx) : INTERFACE_BASE(tx, rx) {
        baud(115200);
    };

protected:
    /** Read a line
     * @param buf   the buffer to store a line
     * @param len   size of the buffer
     * @param timeout   wait time (ms)
     * @return -1 if timeout, length of the line if otherwise
     */
    int readline(char *buf, int len, uint32_t timeout = DEFAULT_TIMEOUT_MS);

    int command(const char* format, ...);

    int match(const char *resp, uint32_t timeout = DEFAULT_TIMEOUT_MS);

    void flush();
    uint8_t read();

private:
    Timer timer;
};

#endif
