/* BLE Color Pixels
 */

#include "mbed.h"
#include "BLEDevice.h"
#include "UARTService.h"
#include "color_pixels.h"

#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

ColorPixels pixels(1, 32);

BLEDevice  ble;
DigitalOut led1(LED1);

UARTService *uartServicePtr;
 

void processPacket(uint8_t *packet)
{
    uint8_t red = packet[0];
    uint8_t green = packet[1];
    uint8_t blue = packet[2];
    
    uint8_t mode = packet[3];
    
    uint8_t number = packet[4] - 1;
    
    mode = mode & 1;
    
    DEBUG("r: %d, g: %d, b: %d, mode: %d\n\r", red, green, blue, mode);
    
    if (mode == 0) {
        pixels.set_color(number, red, green, blue);
        pixels.update();
    } else if (mode == 1) {
        for (int i = 0; i < 32; i++) {
            pixels.set_color(i, red, green, blue);
        }
        pixels.update();
    } else if (mode == 2) {
 
    } else {
        
    }
    
}

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    DEBUG("Disconnected!\n\r");
    
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void onDataWritten(const GattCharacteristicWriteCBParams *params)
{
    if ((uartServicePtr != NULL) && (params->charHandle == uartServicePtr->getTXCharacteristicHandle())) {
        uint16_t bytesRead = params->len;
        DEBUG("received %u bytes\n\r", bytesRead);
        ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
        processPacket((uint8_t *)params->data);
    }
}

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
}

int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    pixels.clear();
    pixels.set_color(0, 255, 0, 0);
    pixels.set_color(0, 0, 255, 0);
    pixels.set_color(0, 0, 0, 255);
    pixels.update();

    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);
 
    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"Color Pixels", sizeof("Color Pixels") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
 
    ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(1000));
    ble.startAdvertising();
 
    UARTService uartService(ble);
    uartServicePtr = &uartService;
 
    while (true) {
        ble.waitForEvent();
    }
}

