#include "mbed.h"
#include "EthernetInterface.h"
#include "IAP.h"


int main() {
    printf("-------- Arch Pro Ethernet -----------\n");
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("MAC Address is %s\n", eth.getMACAddress());
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("httpbin.org", 80);
    
    char http_cmd[] = "GET /get?helloworld HTTP/1.0\r\n\r\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
}

extern "C" void mbed_mac_address(char *mac) {
    IAP iap;
    
    int *serial_number_array = iap.read_serial();   // 4 int
    char *ptr = (char *)serial_number_array;
    
    mac[0] = ptr[0];
    mac[1] = ptr[1];
    mac[2] = ptr[2];
    mac[3] = ptr[3];
    mac[4] = ptr[4];
    mac[5] = ptr[5];
};


