/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-4-26

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "USBSerial.h"

#define PIN_PWR         P1_2    //power up gprs module
#define PIN_PWR_KEY     P1_7
#define PIN_TX          P1_27   //Serial tx pin
#define PIN_RX          P1_26   //Serial rx pin

DigitalOut power(PIN_PWR);
DigitalOut powerKey(PIN_PWR_KEY);
Serial gprs(PIN_TX, PIN_RX);
USBSerial pc;

// Called by ISR
void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};

    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }

    gprs.baud(baud);
    gprs.format(bits, parityTable[parity], stop);
}

/* power pin: low enable
     ___
        |___

   powerKey pin: you can also power up by long press the powerKey.

        ___
    ___|   |___

*/
void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);

    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);

}

int main()
{
    pc.attach(settingsChanged);
    pc.printf("wait for GPRS power up...");
    gprsPowerUp();
    pc.printf("gprs Power up success\n");

    while (1) {
        while (gprs.readable()) {
            pc.putc(gprs.getc());
        }

        while (pc.readable()) {
            gprs.putc(pc.getc());
        }
    }
}