#ifndef ANDANTE_COMMUNICATION_H
#define ANDANTE_COMMUNICATION_H

#include "mbed.h"
#include "iSerial.h"
#include "protocol.h"
#include "Utilities.h"

#define ANDANTE_DEBUG


class COMMUNICATION
{
private:
    Serial *pc; 
    iSerial *serialCom;

public:
    /** Send the MX28 packet over the serial half duplex connection.
    *
    * @param packet The MX28 packet.
    * @return MX28_ERRBIT_NONE if succeeded, error code otherwise.
    */
    uint8_t sendCommunicatePacket(ANDANTE_PROTOCOL_PACKET *packet);
    uint8_t receiveCommunicatePacket(ANDANTE_PROTOCOL_PACKET *packet);

    /** Create an MX28 servo object connected to the specified serial half duplex pins,
    *   with the specified baudrate.
    *
    * @param tx Send pin.
    * @param rx Receive pin.
    * @param baudrate The bus speed.
    */
    COMMUNICATION(PinName tx, PinName rx, uint32_t baudRate, uint16_t tx_buff=1000, uint16_t rx_buff=1000 );

    /** Destroy an MX28 servo object
    */
    ~COMMUNICATION();
};

#endif // MX28_H