#ifndef _PIDCONTROL_H_
#define _PIDCONTROL_H_

#include "mbed.h"

class PID{
    public:
        PID();
        PID(float p,float i,float d);
        void setGoal(float ref);
        //float getGoal();    
        void setCurrent(float sensor);
        float compute();
        
        void setMargin(float gap);
        float getMargin();
        void setIntegalLimit(float limit);
        float getIntegalLimit();
        
        float getErrorNow();
        float getErrorLast();
        float getErrorDiff();
        float getErrorIntegal();
        
        void setKp(float);
        void setKi(float);
        void setKd(float);
        
        float getKp();
        float getKi();
        float getKd();
        
    private:
        float e_n;      //error now
        float e_n_1;    //error last time
        float e_i;      //error integal
        float il;       //integal limit
        float margin;    //output margin
        
        float Kp,Ki,Kd;    
 
        float setpoint;
        float input;    
        float output;
};
    


#endif