#include "main.h"
#include <math.h>


struct FloatVector addVector(struct FloatVector in_vector, int angle, int distance){
    struct FloatVector out_vector;
    float sin_component_old = sin(in_vector.angle * TO_RAD) * in_vector.distance;
    float cos_component_old = cos(in_vector.angle * TO_RAD) * in_vector.distance;
    float sin_component_new = sin(angle * TO_RAD) * distance;
    float cos_component_new = cos(angle * TO_RAD) * distance;
    float sin_component_sum = sin_component_old + sin_component_new;
    float cos_component_sum = cos_component_old + cos_component_new;
    out_vector.distance = sqrt((sin_component_sum * sin_component_sum) + (cos_component_sum * cos_component_sum));
    out_vector.angle = atan2(sin_component_sum ,cos_component_sum) * TO_DEG;
    //out("Angle:%f  Distance:%f\n",out_vector.angle,out_vector.distance);
    return out_vector;
}