/* University of York Robotics Laboratory PsiSwarm Library: PIC and Audio Driver Source File
 * 
 * File: pic.cpp
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Homero Elizondo, Jon Timmis
 * 
 * PsiSwarm Library Version: 0.3
 *
 * October 2015
 *
 */


#include "psiswarm.h"


void play_audio_string(char * tune){
    char length = strlen(tune);
    play_tune(tune,length);   
}

void play_tune(char * tune, char length){
    char to_send [length+3];
    char start_array[2];
    start_array [0] = 'S';
    start_array [1] = length;
    strcpy(to_send,start_array);
    strncat(to_send,tune,length);
    debug(to_send);
    primary_i2c.write(PIC_ADDRESS,to_send,length+2,false);
}


char IF_check_pic_firmware(){
    char buffer[6];
    buffer[0] = 0;
     primary_i2c.write(PIC_ADDRESS,"I",1,false);
     wait(0.1);
     primary_i2c.read(PIC_ADDRESS,buffer,6);   
         debug(buffer); 
    if(buffer[0] != 'F' || buffer[1] != 'W'){
        debug("WARNING:  Cannot read information from PIC microcontroller");
        return 1;
    }
    debug(buffer);
    return 0;
}