/* University of York Robotics Laboratory PsiSwarm Library: I2C Header File
 * 
 * File: i2c.h
 *
 * (C) Dept. Electronics & Computer Science, University of York
 * James Hilder, Alan Millard, Homero Elizondo, Jon Timmis
 * 
 * PsiSwarm Library Version: 0.3
 *
 * October 2015
 *
 */ 
 
#ifndef I2C_H
#define I2C_H

char get_dc_status(void);

char IF_setup_led_expansion_ic(void);
void IF_setup_gpio_expansion_ic(void);

void IF_read_aux_ic_data(void);
void IF_parse_gpio_byte0(char byte);
void IF_parse_gpio_byte1(char byte);
void IF_handle_gpio_interrupt(void);
void IF_update_gpio_inputs(void);
void IF_set_base_LED(char state);
void IF_set_IR_emitter_output(char emitter, char state);
unsigned short IF_read_IR_adc_value(char adc, char index);
char IF_is_switch_pressed(void);
char IF_get_switch_state(void);
void IF_write_to_led_ic(char byte_0, char byte_1);
void IF_setup_temperature_sensor(void);
float IF_read_from_temperature_sensor(void);

#endif