#include "fastADC.h"
#include "mbed.h"

void initADC(){
    GPIOA->MODER   |= (0x03 << 16);              /* Configure PB0 as ADC.8 input      */
    ADC1->CR2        &= 1 << 1;              /* non continuous conversion       */
    ADC1->SQR5       &= ~(0x1f);             /* clear ADC_IN8                     */
    ADC1->SQR5       |= 0x08;                /* set ADC_IN8                     */
    ADC1->CR2        &= ~(1 << 2);           /* Make sure to use bank A      */
    ADC1->CR2        &= ~(3 << 24);          /* set resolution to 12 bits        */
    ADC1->CR2        |= 1 << 0;             /* turn on ADC                   */
    while(!(ADC1->SR & (1 << 6)));
    while((ADC1->SR & (1 << 8)));
}

uint16_t readADC(){
    ADC1->CR2 |= 1 << 30;                   /* Start new conversion               */ 
    while(!(ADC1->SR & (1 << 1)));          /* If conversion has finished         */
    while(!(ADC1->SR & (1 << 6)));
    while((ADC1->SR & (1 << 8)));
    return (uint16_t) ADC1->DR & 0xFFFF;    /* Read AD converted value            */
}