/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
#include <stdio.h>

// Application helper
#include "mbed.h"
#include <AnalogIn.h>
#include <DigitalOut.h>
#include "fastADC.h"


// PIN DEFINITIONS
DigitalOut vcc(GPIO0);
AnalogIn mic(PB_0);
Serial pc(UART_TX, UART_RX, 115200);

// To sleep, 'wait' should be replaced by 'ThisThread::sleep_for' (C++) or 'thread_sleep_for' (C). If you wish to wait (without sleeping), call 'wait_us'. 'wait_us' is safe to call from ISR context. [since mbed-os-5.14] [-Wdeprecated-declarations] in "main.cpp", Line: 59, Col: 9

int main() {
    initADC();
    int ARR_SIZE = 8000;
    vcc = 1;
    uint16_t raw_vals[ARR_SIZE];
    int i = 0; 
    //pc.printf("Loading values...\n");
    while(1) {
        memset(raw_vals, 0, ARR_SIZE * sizeof(uint16_t));
        i = 0;
        for(i; i < ARR_SIZE; i++) { 
            raw_vals[i] = readADC();
            wait_us(100);
        }
        //printf("Done reading in values\n");
        wait(1);
        i = 0;
        for(i; i < ARR_SIZE; i++) { 
            pc.printf("%u,", raw_vals[i]);
        }
        
        while(1);
    }
}
